<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class DynamicInput extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public $items = [],
        public $name = 'item',
        public $placeholder = 'Enter item',
        public $buttonText = 'Add Item',
        public $inputType = 'text',
        public $columnClass = 'col-md-6',
        public $required = true,
        public $icon = 'plus-circle'
    ) {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.dynamic-input');
    }
}
